/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF file access card service sample.
 *
 */

package scfbundle;

import java.util.Iterator;

import jp.co.ricoh.dsdk.scard.framework.card.Card;
import jp.co.ricoh.dsdk.scard.framework.card.CardAccessException;
import jp.co.ricoh.dsdk.scard.framework.service.CardService;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceException;
import jp.co.ricoh.dsdk.scard.framework.service.UnsupportedCardException;
import jp.co.ricoh.dsdk.scard.framework.util.APDUException;
import jp.co.ricoh.dsdk.scard.framework.util.RequestAPDU;
import jp.co.ricoh.dsdk.scard.framework.util.ResponseAPDU;
import jp.co.ricoh.dsdk.scard.option.file.FileAccessService;
import jp.co.ricoh.dsdk.scard.option.file.FileID;
import jp.co.ricoh.dsdk.scard.option.file.FileInfo;
import jp.co.ricoh.dsdk.scard.option.file.FilePath;
import jp.co.ricoh.dsdk.scard.option.security.CHVCallback;
import jp.co.ricoh.dsdk.scard.option.security.CredentialSet;
import jp.co.ricoh.dsdk.scard.option.security.SecurityDomain;
import jp.co.ricoh.dsdk.scard.option.security.VerificationException;

/**
 * MyFileAccessService class
 * This class implements FileAccessService.
 * Only read method and setCallback method are implemented.
 * 
 * MyFileAccessServiceクラス
 * FileAccessServiceを実装したCardServiceです。
 * readメソッド、setCallbackメソッドのみ実装しています。
 */
public class MyFileAccessService extends CardService implements FileAccessService {
	
	/**
	 * Card ATRs which are supported by this CardService.
	 * 
	 * このカードサービスがサポートするカードのATR。
	 */
	private static final byte[][] atr = {
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x63,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x64,(byte)0x02,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x04,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0xE2,(byte)0x00,(byte)0x00,(byte)0x40,(byte)0x20,(byte)0x49,(byte)0x00},
		{(byte)0x3B,(byte)0x85,(byte)0x40,(byte)0x20,(byte)0x68,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x15,(byte)0x40,(byte)0x00,(byte)0x68,(byte)0x01,(byte)0x02,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x01,(byte)0x02,(byte)0x00,(byte)0x00}
	};
	
	/**
	 * Card ATR masks which are supported by this CardService.
	 * 
	 * このカードサービスがサポートするカードのビットマスク。
	 */
	private static final byte[][] mask = {
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00}
	};
	
	/**
	 * The AtrFilter object.
	 * 
	 * ATRフィルタ。
	 */
	private static AtrFilter atrFilter;
	
	/*
	 * initialization of the atr filter.
	 * ATRフィルタ初期化
	 */
	static {
		atrFilter = new AtrFilter();
		for (int i = 0; i < atr.length; i++) {
			atrFilter.put(mask[i], atr[i]);	
		}
	}
	
	/**
	 * Card commands.
	 * 
	 * カードコマンド。
	 */
	private final static byte CLA_CRYPTO     = (byte)0xC0;
    private final static byte INS_SELECTFILE = (byte)0xA4;
    private final static byte INS_READBINARY = (byte)0xB0;
    private final static byte BZ             = (byte)0x00;
    
    /**
     * Status words.
     * 
     * ステータスワード。
     */
	private final static byte SW1_OK         = (byte)0x90;
	
	/**
	 * The CHVCallback object to be used to perform CHV.
	 * 
	 * CHVを行う場合に利用されるCHVCallbackオブジェクト。
	 */
	private CHVCallback callback = null;
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.framework.service.CardService#initialize(jp.co.ricoh.dsdk.scard.framework.card.Card)
	 */
	public synchronized void initialize(Card card) throws UnsupportedCardException, CardServiceException {
		super.initialize(card);
		
		if(!atrFilter.isCandidate(card.getInfo())){
			/*
			 * if the card is not supported by this CardService
			 * サポートしていないカードの場合
			 */
			throw new UnsupportedCardException();
		}
	}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#appendRecord(jp.co.ricoh.dsdk.scard.option.file.FilePath, byte[])
	 */
	public void appendRecord(FilePath arg0, byte[] arg1) throws VerificationException, CardServiceException {}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#exists(jp.co.ricoh.dsdk.scard.option.file.FilePath)
	 */
	public boolean exists(FilePath arg0) throws CardServiceException {return false;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#getFileInfo(jp.co.ricoh.dsdk.scard.option.file.FilePath)
	 */
	public FileInfo getFileInfo(FilePath arg0) throws VerificationException, CardServiceException {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#getRoot()
	 */
	public FilePath getRoot() {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#read(jp.co.ricoh.dsdk.scard.option.file.FilePath, int, int)
	 */
	public byte[] read(FilePath path, int offset, int length) throws VerificationException, CardServiceException {
		RequestAPDU req = null;
		ResponseAPDU res = null;
		
		/*
		 * select the file
		 * ファイル選択
		 */
		Iterator ite = path.iterator();
    	while(ite.hasNext()){
    		FileID id = (FileID)ite.next();
    		
    		try{
    			req = new RequestAPDU(new byte[]{
    					CLA_CRYPTO, 
    					INS_SELECTFILE, 
    					BZ, 
    					BZ
    					});
    			req.append((byte)id.toBytes().length);
    			req.append(id.toBytes());
	    		res = card.getIO().transmit(req);
	    		
	    		if (res.sw1() != SW1_OK) {
	    			throw new CardServiceException("Status word bytes is not successful : " + 
	    					Integer.toHexString(res.statusWords()));
	    		}
	    		
    		} catch(APDUException e){	
                throw new CardServiceException(e);
                
            } catch (CardAccessException e) {
            	throw new CardServiceException(e);
			}
    	}
		
		/*
		 * read the file
		 * ファイル読み取り
		 */
		try {
			req = new RequestAPDU(new byte[]{
					CLA_CRYPTO, 
					INS_READBINARY
					});
	        byte p1 = (byte)(offset/0x100);
	        byte p2 = (byte)(offset%0x100);
	        req.append(p1);
	        req.append(p2);
	        req.append((byte)length);
	        res = card.getIO().transmit(req);
	        
			if (res.sw1() != SW1_OK) {
    			throw new CardServiceException("Status word bytes is not successful : " + 
    					Integer.toHexString(res.statusWords()));
    		}
			
			return res.data();
			
		} catch (APDUException e) {
			throw new CardServiceException(e);
			
		} catch (CardAccessException e) {
			throw new CardServiceException(e);
		}
	}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#readRecord(jp.co.ricoh.dsdk.scard.option.file.FilePath)
	 */
	public byte[] readRecord(FilePath arg0) throws VerificationException, CardServiceException {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#readRecords(jp.co.ricoh.dsdk.scard.option.file.FilePath, int)
	 */
	public byte[][] readRecords(FilePath arg0, int arg1) throws VerificationException, CardServiceException {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#readRecord(jp.co.ricoh.dsdk.scard.option.file.FilePath, int)
	 */
	public byte[] readRecord(FilePath arg0, int arg1) throws VerificationException, CardServiceException {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#readRecords(jp.co.ricoh.dsdk.scard.option.file.FilePath, int, int)
	 */
	public byte[][] readRecords(FilePath arg0, int arg1, int arg2) throws VerificationException, CardServiceException {return null;}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#write(jp.co.ricoh.dsdk.scard.option.file.FilePath, int, byte[])
	 */
	public void write(FilePath arg0, int arg1, byte[] arg2) throws VerificationException, CardServiceException {}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#writeRecord(jp.co.ricoh.dsdk.scard.option.file.FilePath, byte[])
	 */
	public void writeRecord(FilePath arg0, byte[] arg1) throws VerificationException, CardServiceException {}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.file.FileAccessService#writeRecord(jp.co.ricoh.dsdk.scard.option.file.FilePath, int, byte[])
	 */
	public void writeRecord(FilePath arg0, int arg1, byte[] arg2) throws VerificationException, CardServiceException {}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.security.CHVCallbackService#setCallback(jp.co.ricoh.dsdk.scard.option.security.CHVCallback)
	 */
	public void setCallback(CHVCallback callback) {
		this.callback = callback;
	}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.option.security.SecureService#provideCredentials(jp.co.ricoh.dsdk.scard.option.security.SecurityDomain, jp.co.ricoh.dsdk.scard.option.security.CredentialSet)
	 */
	public void provideCredentials(SecurityDomain arg0, CredentialSet arg1) {}
}
